/*
 * Decompiled with CFR 0.152.
 */
package com.eagle.mixsdk.sdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Application;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.support.multidex.MultiDex;
import android.text.TextUtils;
import com.eagle.mixsdk.sdk.IApplicationListener;
import com.eagle.mixsdk.sdk.ProductQueryResult;
import com.eagle.mixsdk.sdk.SDKParams;
import com.eagle.mixsdk.sdk.SDKTools;
import com.eagle.mixsdk.sdk.analytics.UDAgent;
import com.eagle.mixsdk.sdk.base.IActivityCallback;
import com.eagle.mixsdk.sdk.base.IEagleSDKListener;
import com.eagle.mixsdk.sdk.base.PluginFactory;
import com.eagle.mixsdk.sdk.log.Log;
import com.eagle.mixsdk.sdk.plugin.EagleAnalytics;
import com.eagle.mixsdk.sdk.plugin.EagleDownload;
import com.eagle.mixsdk.sdk.plugin.EaglePay;
import com.eagle.mixsdk.sdk.plugin.EaglePush;
import com.eagle.mixsdk.sdk.plugin.EagleRYAnalytics;
import com.eagle.mixsdk.sdk.plugin.EagleShare;
import com.eagle.mixsdk.sdk.plugin.EagleUser;
import com.eagle.mixsdk.sdk.verify.EagleProxy;
import com.eagle.mixsdk.sdk.verify.EagleToken;
import java.util.ArrayList;
import java.util.List;

public class EagleSDK {
    private static final String DEFAULT_PKG_NAME = "com.eagle.mixsdk.sdk";
    private static final String APP_PROXY_NAME = "Eagle_APPLICATION_PROXY_NAME";
    private static final String APP_GAME_NAME = "Eagle_Game_Application";
    private static EagleSDK instance;
    private Application application;
    private Activity context;
    private Handler mainThreadHandler = new Handler(Looper.getMainLooper());
    private SDKParams developInfo;
    private Bundle metaData;
    private List<IEagleSDKListener> listeners = new ArrayList<IEagleSDKListener>();
    private List<IActivityCallback> activityCallbacks = new ArrayList<IActivityCallback>(1);
    private List<IApplicationListener> applicationListeners = new ArrayList<IApplicationListener>(2);
    private String sdkUserID = null;
    private EagleToken tokenData = null;

    private EagleSDK() {
    }

    public static EagleSDK getInstance() {
        if (instance == null) {
            instance = new EagleSDK();
        }
        return instance;
    }

    public SDKParams getSDKParams() {
        return this.developInfo;
    }

    public Bundle getMetaData() {
        return this.metaData;
    }

    public int getSubChannel() {
        if (this.developInfo == null || !this.developInfo.contains("Eagle_Sub_Channel")) {
            return 0;
        }
        return this.developInfo.getInt("Eagle_Sub_Channel");
    }

    public int getCurrChannel() {
        if (this.developInfo == null || !this.developInfo.contains("Eagle_Channel")) {
            return 0;
        }
        return this.developInfo.getInt("Eagle_Channel");
    }

    public int getAppID() {
        if (this.developInfo == null || !this.developInfo.contains("Eagle_APPID")) {
            return 0;
        }
        return this.developInfo.getInt("Eagle_APPID");
    }

    public String getAppKey() {
        if (this.developInfo == null || !this.developInfo.contains("Eagle_APPKEY")) {
            return "";
        }
        return this.developInfo.getString("Eagle_APPKEY");
    }

    public String getPayPrivateKey() {
        if (this.developInfo == null || !this.developInfo.contains("Eagle_PAY_PRIVATEKEY")) {
            return "";
        }
        return this.developInfo.getString("Eagle_PAY_PRIVATEKEY");
    }

    public boolean isAuth() {
        return this.getAuthURL() != null;
    }

    public boolean isGetOrder() {
        return this.getOrderURL() != null;
    }

    public String getOrderURL() {
        if (this.developInfo == null) {
            return null;
        }
        if (this.developInfo.contains("Eagle_ORDER_URL")) {
            return this.developInfo.getString("Eagle_ORDER_URL");
        }
        String baseUrl = this.getEagleServerURL();
        if (baseUrl == null) {
            return null;
        }
        return String.valueOf(baseUrl) + "/pay/getOrderID";
    }

    public String getAuthURL() {
        if (this.developInfo == null) {
            return null;
        }
        if (this.developInfo.contains("Eagle_AUTH_URL")) {
            return this.developInfo.getString("Eagle_AUTH_URL");
        }
        String baseUrl = this.getEagleServerURL();
        if (baseUrl == null) {
            return null;
        }
        return String.valueOf(baseUrl) + "/user/getToken";
    }

    public String getAnalyticsURL() {
        if (this.developInfo == null) {
            return null;
        }
        if (this.developInfo.contains("Eagle_ANALYTICS_URL")) {
            return this.developInfo.getString("Eagle_ANALYTICS_URL");
        }
        String baseUrl = this.getEagleServerURL();
        if (baseUrl == null) {
            return null;
        }
        return String.valueOf(baseUrl) + "/user";
    }

    /*
     * Unable to fully structure code
     */
    public String getEagleServerURL() {
        if (this.developInfo == null || !this.developInfo.contains("Eagle_SERVER_URL")) {
            return null;
        }
        url = this.developInfo.getString("Eagle_SERVER_URL");
        if (url != null && url.trim().length() != 0) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            url = url.substring(0, url.length() - 1);
lbl7:
            // 2 sources

            ** while (url.endsWith((String)"/"))
        }
lbl8:
        // 1 sources

        return url;
    }

    public boolean isUseEagleAnalytics() {
        if (this.developInfo == null || !this.developInfo.contains("Eagle_ANALYTICS")) {
            return false;
        }
        String use = this.developInfo.getString("Eagle_ANALYTICS");
        return "true".equalsIgnoreCase(use);
    }

    public boolean isSDKShowSplash() {
        if (this.developInfo == null || !this.developInfo.contains("Eagle_SDK_SHOW_SPLASH")) {
            return false;
        }
        String show = this.developInfo.getString("Eagle_SDK_SHOW_SPLASH");
        return "true".equalsIgnoreCase(show);
    }

    public String getSDKVersionCode() {
        if (this.developInfo == null || !this.developInfo.contains("Eagle_SDK_VERSION_CODE")) {
            return "";
        }
        return this.developInfo.getString("Eagle_SDK_VERSION_CODE");
    }

    public void setSDKListener(IEagleSDKListener listener) {
        if (!this.listeners.contains(listener) && listener != null) {
            this.listeners.add(listener);
        }
    }

    public void setActivityCallback(IActivityCallback callback) {
        if (!this.activityCallbacks.contains(callback) && callback != null) {
            this.activityCallbacks.add(callback);
        }
    }

    public Application getApplication() {
        return this.application;
    }

    public String getSDKUserID() {
        return this.sdkUserID;
    }

    public EagleToken getUToken() {
        return this.tokenData;
    }

    public void onAppCreate(Application application) {
        this.application = application;
        for (IApplicationListener lis : this.applicationListeners) {
            lis.onProxyCreate();
        }
    }

    public void onAppAttachBaseContext(Application application, Context context) {
        String gameAppName;
        IApplicationListener listener;
        this.application = application;
        MultiDex.install((Context)context);
        Log.init(context);
        this.applicationListeners.clear();
        PluginFactory.getInstance().loadPluginInfo(context);
        this.developInfo = PluginFactory.getInstance().getSDKParams(context);
        this.metaData = PluginFactory.getInstance().getMetaData(context);
        if (this.metaData.containsKey(APP_PROXY_NAME)) {
            String[] proxyApps;
            String proxyAppNames = this.metaData.getString(APP_PROXY_NAME);
            Log.d("EagleSDK", "proxyAppNames:" + proxyAppNames);
            String[] stringArray = proxyApps = proxyAppNames.split(",");
            int n = proxyApps.length;
            int n2 = 0;
            while (n2 < n) {
                String proxy = stringArray[n2];
                if (!TextUtils.isEmpty((CharSequence)proxy)) {
                    Log.d("EagleSDK", "add a new application listener:" + proxy);
                    IApplicationListener listener2 = this.newApplicationInstance(application, proxy);
                    if (listener2 != null) {
                        this.applicationListeners.add(listener2);
                    }
                }
                ++n2;
            }
        }
        if (this.metaData.containsKey(APP_GAME_NAME) && (listener = this.newApplicationInstance(application, gameAppName = this.metaData.getString(APP_GAME_NAME))) != null) {
            Log.e("EagleSDK", "add a game application listener:" + gameAppName);
            this.applicationListeners.add(listener);
        }
        for (IApplicationListener lis : this.applicationListeners) {
            lis.onProxyAttachBaseContext(context);
        }
    }

    public void onAppConfigurationChanged(Application application, Configuration newConfig) {
        for (IApplicationListener lis : this.applicationListeners) {
            lis.onProxyConfigurationChanged(newConfig);
        }
    }

    public void onTerminate() {
        for (IApplicationListener lis : this.applicationListeners) {
            lis.onProxyTerminate();
        }
        Log.destory();
    }

    private IApplicationListener newApplicationInstance(Application application, String proxyAppName) {
        if (proxyAppName == null || SDKTools.isNullOrEmpty(proxyAppName)) {
            return null;
        }
        if (proxyAppName.startsWith(".")) {
            proxyAppName = DEFAULT_PKG_NAME + proxyAppName;
        }
        try {
            Class<?> clazz = Class.forName(proxyAppName);
            return (IApplicationListener)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void init(Activity context) {
        this.context = context;
        try {
            if (this.isUseEagleAnalytics()) {
                UDAgent.getInstance().init(context);
            }
            EaglePush.getInstance().init();
            EagleUser.getInstance().init();
            EaglePay.getInstance().init();
            EagleShare.getInstance().init();
            EagleAnalytics.getInstance().init();
            EagleDownload.getInstance().init();
            EagleRYAnalytics.getInstance().init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void runOnMainThread(Runnable runnable) {
        if (this.mainThreadHandler != null) {
            this.mainThreadHandler.post(runnable);
            return;
        }
        if (this.context != null) {
            this.context.runOnUiThread(runnable);
        }
    }

    public void setContext(Activity context) {
        this.context = context;
    }

    public Activity getContext() {
        return this.context;
    }

    public void onResult(int code, String msg) {
        for (IEagleSDKListener listener : this.listeners) {
            listener.onResult(code, msg);
        }
    }

    public void onLoginResult(String result) {
        for (IEagleSDKListener listener : this.listeners) {
            listener.onLoginResult(result);
        }
        if (this.isAuth()) {
            this.startAuthTask(result);
        }
    }

    public void onSwitchAccount() {
        for (IEagleSDKListener listener : this.listeners) {
            listener.onSwitchAccount();
        }
    }

    public void onSwitchAccount(String result) {
        for (IEagleSDKListener listener : this.listeners) {
            listener.onSwitchAccount(result);
        }
        if (this.isAuth()) {
            this.startAuthTask(result);
        }
    }

    public void onLogout() {
        for (IEagleSDKListener listener : this.listeners) {
            listener.onLogout();
        }
    }

    private void onAuthResult(EagleToken token) {
        if (token.isSuc()) {
            this.sdkUserID = token.getSdkUserID();
            this.tokenData = token;
        }
        for (IEagleSDKListener listener : this.listeners) {
            listener.onAuthResult(token);
        }
    }

    public void onProductQueryResult(List<ProductQueryResult> result) {
        for (IEagleSDKListener listener : this.listeners) {
            listener.onProductQueryResult(result);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.activityCallbacks != null) {
            for (IActivityCallback callback : this.activityCallbacks) {
                callback.onActivityResult(requestCode, resultCode, data);
            }
        }
    }

    public void onBackPressed() {
        if (this.activityCallbacks != null) {
            for (IActivityCallback callback : this.activityCallbacks) {
                callback.onBackPressed();
            }
        }
    }

    public void onCreate() {
        if (this.activityCallbacks != null) {
            for (IActivityCallback callback : this.activityCallbacks) {
                callback.onCreate();
            }
        }
    }

    public void onStart() {
        if (this.activityCallbacks != null) {
            for (IActivityCallback callback : this.activityCallbacks) {
                callback.onStart();
            }
        }
    }

    public void onPause() {
        if (this.activityCallbacks != null) {
            for (IActivityCallback callback : this.activityCallbacks) {
                callback.onPause();
            }
        }
    }

    public void onResume() {
        if (this.activityCallbacks != null) {
            for (IActivityCallback callback : this.activityCallbacks) {
                callback.onResume();
            }
        }
    }

    public void onNewIntent(Intent newIntent) {
        if (this.activityCallbacks != null) {
            for (IActivityCallback callback : this.activityCallbacks) {
                callback.onNewIntent(newIntent);
            }
        }
    }

    public void onStop() {
        if (this.activityCallbacks != null) {
            for (IActivityCallback callback : this.activityCallbacks) {
                callback.onStop();
            }
        }
    }

    public void onDestroy() {
        if (this.activityCallbacks != null) {
            for (IActivityCallback callback : this.activityCallbacks) {
                callback.onDestroy();
            }
        }
    }

    public void onRestart() {
        if (this.activityCallbacks != null) {
            for (IActivityCallback callback : this.activityCallbacks) {
                callback.onRestart();
            }
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        if (this.activityCallbacks != null) {
            for (IActivityCallback callback : this.activityCallbacks) {
                callback.onConfigurationChanged(newConfig);
            }
        }
    }

    public void onRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) {
        if (this.activityCallbacks != null) {
            for (IActivityCallback callback : this.activityCallbacks) {
                callback.onRequestPermissionResult(requestCode, permissions, grantResults);
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    private void startAuthTask(String result) {
        AuthTask authTask = new AuthTask();
        if (Build.VERSION.SDK_INT >= 11) {
            authTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[]{result});
        } else {
            authTask.execute(new String[]{result});
        }
    }

    public void exitDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.context);
        builder.setTitle((CharSequence)"\u9000\u51fa\u63d0\u793a");
        builder.setMessage((CharSequence)"\u73b0\u5728\u8fd8\u65e9\uff0c\u8981\u4e0d\u8981\u518d\u73a9\u4e00\u4f1a\uff1f");
        builder.setCancelable(true);
        builder.setPositiveButton((CharSequence)"\u597d\u5427", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
            }
        });
        builder.setNeutralButton((CharSequence)"\u4e00\u4f1a\u518d\u73a9", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                System.exit(0);
                Process.killProcess((int)Process.myPid());
            }
        });
        builder.show();
    }

    class AuthTask
    extends AsyncTask<String, Void, EagleToken> {
        AuthTask() {
        }

        protected EagleToken doInBackground(String ... args) {
            String result = args[0];
            Log.d("EagleSDK", "begin to auth...");
            EagleToken token = EagleProxy.auth(result);
            return token;
        }

        protected void onPostExecute(EagleToken token) {
            EagleSDK.this.onAuthResult(token);
        }
    }
}

