/*
 * Decompiled with CFR 0.152.
 */
package com.eagle.mixsdk.sdk.analytics;

import android.app.Activity;
import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;
import com.eagle.mixsdk.sdk.EagleSDK;
import com.eagle.mixsdk.sdk.UserExtraData;
import com.eagle.mixsdk.sdk.analytics.UDManager;
import com.eagle.mixsdk.sdk.analytics.UDevice;
import com.eagle.mixsdk.sdk.analytics.UUserLog;
import com.eagle.mixsdk.sdk.utils.GUtils;
import com.eagle.mixsdk.sdk.verify.EagleToken;

public class UDAgent {
    private static UDAgent instance;

    private UDAgent() {
    }

    public static UDAgent getInstance() {
        if (instance == null) {
            instance = new UDAgent();
        }
        return instance;
    }

    public void init(final Activity context) {
        try {
            final UDevice device = UDManager.getInstance().collectDeviceInfo(context, EagleSDK.getInstance().getAppID(), EagleSDK.getInstance().getCurrChannel(), EagleSDK.getInstance().getSubChannel());
            if (device == null) {
                Log.e((String)"EagleSDK", (String)"collect device info failed");
                return;
            }
            SubmitTask task = new SubmitTask(new ISubmitListener(){

                @Override
                public void run() {
                    UDManager.getInstance().submitDeviceInfo(context, EagleSDK.getInstance().getAnalyticsURL(), EagleSDK.getInstance().getAppKey(), device);
                }
            });
            task.execute(new Void[0]);
        }
        catch (Exception e) {
            Log.e((String)"EagleSDK", (String)("submit device info failed.\n" + e.getMessage()));
            e.printStackTrace();
        }
    }

    public void submitUserInfo(final Activity context, UserExtraData user) {
        try {
            EagleToken token = EagleSDK.getInstance().getUToken();
            if (token == null) {
                Log.e((String)"EagleSDK", (String)"utoken is null. submit user info failed.");
                return;
            }
            final UUserLog log = new UUserLog();
            boolean sendable = false;
            switch (user.getDataType()) {
                case 2: {
                    log.setOpType(1);
                    sendable = true;
                    break;
                }
                case 3: {
                    sendable = true;
                    log.setOpType(2);
                    break;
                }
                case 4: {
                    sendable = true;
                    log.setOpType(3);
                    break;
                }
                case 5: {
                    sendable = true;
                    log.setOpType(4);
                }
            }
            if (sendable) {
                log.setUserID(token.getUserID());
                log.setAppID(EagleSDK.getInstance().getAppID());
                log.setChannelID(EagleSDK.getInstance().getCurrChannel());
                log.setServerID(String.valueOf(user.getServerID()));
                log.setServerName(user.getServerName());
                log.setRoleID(user.getRoleID());
                log.setRoleName(user.getRoleName());
                log.setRoleLevel(user.getRoleLevel());
                log.setDeviceID(GUtils.getDeviceID((Context)context));
                SubmitTask task = new SubmitTask(new ISubmitListener(){

                    @Override
                    public void run() {
                        UDManager.getInstance().submitUserInfo(context, EagleSDK.getInstance().getAnalyticsURL(), EagleSDK.getInstance().getAppKey(), log);
                    }
                });
                task.execute(new Void[0]);
            }
        }
        catch (Exception e) {
            Log.e((String)"EagleSDK", (String)("submit user info failed.\n" + e.getMessage()));
            e.printStackTrace();
        }
    }

    static interface ISubmitListener {
        public void run();
    }

    class SubmitTask
    extends AsyncTask<Void, Void, Void> {
        private ISubmitListener runListener;

        public SubmitTask(ISubmitListener run) {
            this.runListener = run;
        }

        protected Void doInBackground(Void ... arg) {
            if (this.runListener != null) {
                this.runListener.run();
            }
            return null;
        }
    }
}

