/*
 * Decompiled with CFR 0.152.
 */
package com.eagle.mixsdk.sdk.analytics;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import com.eagle.mixsdk.sdk.EagleSDK;
import com.eagle.mixsdk.sdk.analytics.UDevice;
import com.eagle.mixsdk.sdk.analytics.UUserLog;
import com.eagle.mixsdk.sdk.log.Log;
import com.eagle.mixsdk.sdk.utils.EagleHttpUtils;
import com.eagle.mixsdk.sdk.utils.EncryptUtils;
import com.eagle.mixsdk.sdk.utils.GUtils;
import java.util.HashMap;
import org.json.JSONObject;

public class UDManager {
    private static UDManager instance;

    private UDManager() {
    }

    public static UDManager getInstance() {
        if (instance == null) {
            instance = new UDManager();
        }
        return instance;
    }

    public void submitUserInfo(Activity context, String url, String appKey, UUserLog log) {
        try {
            Log.d("EagleSDK", "begin submit user info to eagle server:" + log.getOpType());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("userID", "" + log.getUserID());
            params.put("appID", "" + log.getAppID());
            params.put("channelID", "" + log.getChannelID());
            params.put("serverID", log.getServerID());
            params.put("serverName", log.getServerName());
            params.put("roleID", log.getRoleID());
            params.put("roleName", log.getRoleName());
            params.put("roleLevel", log.getRoleLevel());
            params.put("deviceID", log.getDeviceID());
            params.put("opType", "" + log.getOpType());
            StringBuilder sb = new StringBuilder();
            sb.append("appID=").append(log.getAppID()).append("channelID=").append(log.getChannelID()).append("deviceID=").append(log.getDeviceID()).append("opType=").append(log.getOpType()).append("roleID=").append(log.getRoleID()).append("roleLevel=").append(log.getRoleLevel()).append("roleName=").append(log.getRoleName()).append("serverID=").append(log.getServerID()).append("serverName=").append(log.getServerName()).append("userID=").append(log.getUserID()).append(appKey);
            String sign = EncryptUtils.md5(sb.toString()).toLowerCase();
            params.put("sign", sign);
            url = String.valueOf(url) + "/addUserLog";
            String result = EagleHttpUtils.httpGet(url, params);
            Log.d("EagleSDK", "The sign is " + sign + " The result is " + result);
            if (result != null && result.trim().length() > 0) {
                JSONObject jsonObj = new JSONObject(result);
                int state = jsonObj.getInt("state");
                if (state != 1) {
                    Log.d("EagleSDK", "submit user info failed. the state is " + state);
                } else {
                    Log.d("EagleSDK", "submit user info success");
                }
            }
        }
        catch (Exception e) {
            Log.e("EagleSDK", "submit user info failed.\n" + e.getMessage());
            e.printStackTrace();
        }
    }

    public void submitDeviceInfo(Activity context, String url, String appKey, UDevice device) {
        try {
            Log.d("EagleSDK", "begin submit device info to eagle server");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("appID", "" + device.getAppID());
            params.put("deviceID", device.getDeviceID());
            params.put("mac", device.getMac());
            params.put("deviceType", device.getDeviceType());
            params.put("deviceOS", "" + device.getDeviceOS());
            String dpi = device.getDeviceDpi();
            dpi = dpi.replace("\u00d7", "#");
            params.put("deviceDpi", dpi);
            params.put("channelID", "" + device.getChannelID());
            params.put("subChannelID", device.getSubChannelID() == null ? "0" : "" + device.getSubChannelID());
            StringBuilder sb = new StringBuilder();
            sb.append("appID=").append("" + device.getAppID()).append("channelID=").append(device.getChannelID()).append("deviceDpi=").append(dpi).append("deviceID=").append(device.getDeviceID()).append("deviceOS=").append(device.getDeviceOS()).append("deviceType=").append(device.getDeviceType()).append("mac=").append(device.getMac()).append(appKey);
            String sign = EncryptUtils.md5(sb.toString()).toLowerCase();
            params.put("sign", sign);
            url = String.valueOf(url) + "/addDevice";
            String result = EagleHttpUtils.httpGet(url, params);
            Log.d("EagleSDK", "sign str:" + sb.toString());
            Log.d("EagleSDK", "The sign is " + sign + " The result is " + result);
            if (result != null && result.trim().length() > 0) {
                JSONObject jsonObj = new JSONObject(result);
                int state = jsonObj.getInt("state");
                if (state != 1) {
                    Log.d("EagleSDK", "submit device info failed. the state is " + state);
                } else {
                    Log.d("EagleSDK", "submit device info success");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e("EagleSDK", "submit device info failed.\n" + e.getMessage());
        }
    }

    public UDevice collectDeviceInfo(Activity context, Integer appID, Integer channelID, Integer subChannelID) {
        try {
            UDevice device = new UDevice();
            device.setAppID(appID);
            device.setChannelID(channelID);
            device.setSubChannelID(EagleSDK.getInstance().getSubChannel());
            device.setDeviceID(GUtils.getDeviceID((Context)context));
            device.setMac(GUtils.getMacAddress((Context)context));
            device.setDeviceType(Build.MODEL);
            device.setDeviceOS(1);
            device.setDeviceDpi(GUtils.getScreenDpi(context));
            return device;
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e("EagleSDK", e.getMessage());
            return null;
        }
    }
}

