/*
 * Decompiled with CFR 0.152.
 */
package com.eagle.mixsdk.sdk.base;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Xml;
import com.eagle.mixsdk.sdk.EagleSDK;
import com.eagle.mixsdk.sdk.SDKParams;
import com.eagle.mixsdk.sdk.SDKTools;
import com.eagle.mixsdk.sdk.log.Log;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@SuppressLint(value={"UseSparseArrays"})
public class PluginFactory {
    private static PluginFactory instance;
    private Map<Integer, String> supportedPlugins = new HashMap<Integer, String>();

    private PluginFactory() {
    }

    public static PluginFactory getInstance() {
        if (instance == null) {
            instance = new PluginFactory();
        }
        return instance;
    }

    private boolean isSupportPlugin(int type) {
        return this.supportedPlugins.containsKey(type);
    }

    private String getPluginName(int type) {
        if (this.supportedPlugins.containsKey(type)) {
            return this.supportedPlugins.get(type);
        }
        return null;
    }

    public Bundle getMetaData(Context context) {
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (appInfo != null && appInfo.metaData != null) {
                return appInfo.metaData;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return new Bundle();
    }

    public SDKParams getSDKParams(Context context) {
        Map<String, String> configs = SDKTools.getAssetPropConfig(context, "eagle_developer_config.properties");
        return new SDKParams(configs);
    }

    public Object initPlugin(int type) {
        Class<?> localClass;
        block9: {
            localClass = null;
            try {
                if (this.isSupportPlugin(type)) break block9;
                if (type == 1 || type == 2) {
                    Log.e("EagleSDK", "The config of the EagleSDK is not support plugin type:" + type);
                } else {
                    Log.w("EagleSDK", "The config of the EagleSDK is not support plugin type:" + type);
                }
                return null;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }
        String pluginName = this.getPluginName(type);
        localClass = Class.forName(pluginName);
        try {
            return localClass.getDeclaredConstructor(Activity.class).newInstance(EagleSDK.getInstance().getContext());
        }
        catch (Exception e) {
            try {
                return localClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                e.printStackTrace();
                return null;
            }
        }
    }

    public void loadPluginInfo(Context context) {
        String xmlPlugins = SDKTools.getAssetConfigs(context, "eagle_plugin_config.xml");
        if (xmlPlugins == null) {
            Log.e("EagleSDK", "fail to load plugin_config.xml");
            return;
        }
        XmlPullParser parser = Xml.newPullParser();
        try {
            parser.setInput((Reader)new StringReader(xmlPlugins));
            int eventType = parser.getEventType();
            while (eventType != 1) {
                switch (eventType) {
                    case 2: {
                        String tag = parser.getName();
                        if (!"plugin".equals(tag)) break;
                        String name = parser.getAttributeValue(0);
                        int type = Integer.parseInt(parser.getAttributeValue(1));
                        this.supportedPlugins.put(type, name);
                        Log.d("EagleSDK", "Curr Supported Plugin: " + type + "; name:" + name);
                    }
                }
                eventType = parser.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

