/*
 * Decompiled with CFR 0.152.
 */
package com.eagle.mixsdk.sdk.log;

import com.eagle.mixsdk.sdk.log.ULog;
import com.eagle.mixsdk.sdk.utils.EagleHttpUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class URemoteLogPrinter {
    private List<ULog> logs;
    private String url;
    private int interval = 1000;
    private Timer timer;
    private boolean running;

    public URemoteLogPrinter() {
    }

    public URemoteLogPrinter(String remoteUrl, int interval) {
        this.logs = Collections.synchronizedList(new ArrayList());
        this.url = remoteUrl;
        this.interval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(ULog log) {
        this.start();
        List<ULog> list = this.logs;
        synchronized (list) {
            this.logs.add(log);
        }
    }

    public void printImmediate(String url, ULog log) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("log", log.toJSON());
        EagleHttpUtils.httpPost(url, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ULog> getAndClear() {
        List<ULog> list = this.logs;
        synchronized (list) {
            ArrayList<ULog> all = new ArrayList<ULog>(this.logs);
            this.logs.clear();
            return all;
        }
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        LogPrintTask task = new LogPrintTask();
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate((TimerTask)task, 100L, (long)this.interval);
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.running = false;
    }

    class LogPrintTask
    extends TimerTask {
        LogPrintTask() {
        }

        @Override
        public void run() {
            try {
                List<ULog> logs = URemoteLogPrinter.this.getAndClear();
                if (logs.size() > 0) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("[");
                    for (ULog log : logs) {
                        sb.append(log.toJSON()).append(",");
                    }
                    sb.deleteCharAt(sb.length() - 1).append("]");
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("log", sb.toString());
                    EagleHttpUtils.httpPost(URemoteLogPrinter.this.url, params);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                URemoteLogPrinter.this.stop();
            }
        }
    }
}

