/*
 * Decompiled with CFR 0.152.
 */
package com.eagle.mixsdk.sdk.platform;

import android.app.Activity;
import android.content.Intent;
import android.content.res.Configuration;
import com.eagle.mixsdk.sdk.EagleSDK;
import com.eagle.mixsdk.sdk.PayParams;
import com.eagle.mixsdk.sdk.ProductQueryResult;
import com.eagle.mixsdk.sdk.UserExtraData;
import com.eagle.mixsdk.sdk.base.IEagleSDKListener;
import com.eagle.mixsdk.sdk.log.Log;
import com.eagle.mixsdk.sdk.platform.EagleExitListener;
import com.eagle.mixsdk.sdk.platform.EagleInitListener;
import com.eagle.mixsdk.sdk.plugin.EaglePay;
import com.eagle.mixsdk.sdk.plugin.EagleUser;
import com.eagle.mixsdk.sdk.verify.EagleToken;
import java.util.List;

public class EaglePlatform {
    private static EaglePlatform instance;
    private boolean isSwitchAccount = false;

    private EaglePlatform() {
    }

    public static EaglePlatform getInstance() {
        if (instance == null) {
            instance = new EaglePlatform();
        }
        return instance;
    }

    public void init(Activity context, final EagleInitListener callback) {
        if (callback == null) {
            Log.d("EagleSDK", "EagleInitListener must be not null.");
            return;
        }
        try {
            EagleSDK.getInstance().setSDKListener(new IEagleSDKListener(){

                @Override
                public void onResult(final int code, final String msg) {
                    Log.d("EagleSDK", "onResult.code:" + code + ";msg:" + msg);
                    EagleSDK.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            switch (code) {
                                case 1: {
                                    callback.onInitResult(1, msg);
                                    break;
                                }
                                case 2: {
                                    callback.onInitResult(2, msg);
                                    break;
                                }
                                case 5: {
                                    callback.onLoginFail(code, msg);
                                    break;
                                }
                                case 10: {
                                    callback.onPayResult(10, msg);
                                    break;
                                }
                                case 11: {
                                    callback.onPayResult(11, msg);
                                    break;
                                }
                                case 33: {
                                    callback.onPayResult(33, msg);
                                    break;
                                }
                                case 34: {
                                    callback.onPayResult(34, msg);
                                    break;
                                }
                                case 35: {
                                    callback.onPayResult(35, msg);
                                    break;
                                }
                                case 36: {
                                    EagleSDK.getInstance().exitDialog();
                                    break;
                                }
                            }
                        }
                    });
                }

                @Override
                public void onLogout() {
                    EagleSDK.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            callback.onLogout();
                        }
                    });
                }

                @Override
                public void onSwitchAccount() {
                    EagleSDK.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            callback.onLogout();
                        }
                    });
                }

                @Override
                public void onLoginResult(String data) {
                    Log.d("EagleSDK", "SDK \u767b\u5f55\u6210\u529f,\u4e0d\u7528\u505a\u5904\u7406\uff0c\u5728onAuthResult\u4e2d\u5904\u7406\u767b\u5f55\u6210\u529f, \u53c2\u6570\u5982\u4e0b:");
                    Log.d("EagleSDK", data);
                    EaglePlatform.this.isSwitchAccount = false;
                }

                @Override
                public void onSwitchAccount(String data) {
                    Log.d("EagleSDK", "SDK \u5207\u6362\u5e10\u53f7\u5e76\u767b\u5f55\u6210\u529f,\u4e0d\u7528\u505a\u5904\u7406\uff0c\u5728onAuthResult\u4e2d\u5904\u7406\u767b\u5f55\u6210\u529f, \u53c2\u6570\u5982\u4e0b:");
                    Log.d("EagleSDK", data);
                    EaglePlatform.this.isSwitchAccount = true;
                }

                @Override
                public void onAuthResult(final EagleToken authResult) {
                    EagleSDK.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (EaglePlatform.this.isSwitchAccount) {
                                if (authResult.isSuc()) {
                                    callback.onSwitchAccount(authResult);
                                } else {
                                    Log.e("EagleSDK", "switch account auth failed.");
                                }
                            } else {
                                if (!authResult.isSuc()) {
                                    callback.onLoginResult(5, null);
                                    return;
                                }
                                callback.onLoginResult(4, authResult);
                            }
                        }
                    });
                }

                @Override
                public void onProductQueryResult(List<ProductQueryResult> result) {
                    if (result == null) {
                        Log.e("EagleSDK", "product query result with null. ");
                        return;
                    }
                    Log.d("EagleSDK", "product query result:" + result.size());
                    callback.onProductQueryResult(result);
                }
            });
            EagleSDK.getInstance().init(context);
            EagleSDK.getInstance().onCreate();
        }
        catch (Exception e) {
            callback.onInitResult(2, e.getMessage());
            Log.e("EagleSDK", "init failed.", e);
            e.printStackTrace();
        }
    }

    public void login(Activity context) {
        EagleSDK.getInstance().setContext(context);
        EagleSDK.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                EagleUser.getInstance().login();
            }
        });
    }

    public void logout() {
        EagleSDK.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (EagleUser.getInstance().isSupport("logout")) {
                    EagleUser.getInstance().logout();
                }
            }
        });
    }

    public void showAccountCenter() {
        EagleSDK.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (EagleUser.getInstance().isSupport("showAccountCenter")) {
                    EagleUser.getInstance().showAccountCenter();
                }
            }
        });
    }

    public void submitExtraData(final UserExtraData data) {
        EagleSDK.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                EagleUser.getInstance().submitExtraData(data);
            }
        });
    }

    public void exitSDK(final EagleExitListener callback) {
        EagleSDK.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (EagleUser.getInstance().isSupport("exit")) {
                    EagleUser.getInstance().exit();
                } else {
                    if (callback != null) {
                        callback.onGameExit();
                    }
                    EagleSDK.getInstance().exitDialog();
                }
            }
        });
    }

    public void pay(Activity context, final PayParams data) {
        EagleSDK.getInstance().setContext(context);
        EagleSDK.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                EaglePay.getInstance().pay(data);
            }
        });
    }

    public void queryProducts(Activity context) {
        EagleSDK.getInstance().setContext(context);
        EagleSDK.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                EagleUser.getInstance().queryProducts();
            }
        });
    }

    public boolean isSupportMethod(String method) {
        return EagleUser.getInstance().isSupport(method);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        EagleSDK.getInstance().onActivityResult(requestCode, resultCode, data);
    }

    public void onStart() {
        EagleSDK.getInstance().onStart();
    }

    public void onPause() {
        EagleSDK.getInstance().onPause();
    }

    public void onResume() {
        EagleSDK.getInstance().onResume();
    }

    public void onNewIntent(Intent newIntent) {
        EagleSDK.getInstance().onNewIntent(newIntent);
    }

    public void onStop() {
        EagleSDK.getInstance().onStop();
    }

    public void onDestroy() {
        EagleSDK.getInstance().onDestroy();
    }

    public void onRestart() {
        EagleSDK.getInstance().onRestart();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        EagleSDK.getInstance().onConfigurationChanged(newConfig);
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        EagleSDK.getInstance().onRequestPermissionResult(requestCode, permissions, grantResults);
    }
}

