/*
 * Decompiled with CFR 0.152.
 */
package com.eagle.mixsdk.sdk.plugin;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.widget.Toast;
import com.eagle.mixsdk.sdk.EagleSDK;
import com.eagle.mixsdk.sdk.IPay;
import com.eagle.mixsdk.sdk.PayParams;
import com.eagle.mixsdk.sdk.SDKTools;
import com.eagle.mixsdk.sdk.base.PluginFactory;
import com.eagle.mixsdk.sdk.impl.SimpleDefaultPay;
import com.eagle.mixsdk.sdk.log.Log;
import com.eagle.mixsdk.sdk.verify.EagleOrder;
import com.eagle.mixsdk.sdk.verify.EagleProxy;

public class EaglePay {
    private static EaglePay instance;
    private IPay payPlugin;

    private EaglePay() {
    }

    public static EaglePay getInstance() {
        if (instance == null) {
            instance = new EaglePay();
        }
        return instance;
    }

    public void init() {
        this.payPlugin = (IPay)PluginFactory.getInstance().initPlugin(2);
        if (this.payPlugin == null) {
            this.payPlugin = new SimpleDefaultPay();
        }
    }

    public boolean isSupport(String method) {
        if (this.payPlugin == null) {
            return false;
        }
        return this.payPlugin.isSupportMethod(method);
    }

    public void pay(PayParams data) {
        if (this.payPlugin == null) {
            return;
        }
        Log.d("EagleSDK", "****PayParams Print Begin****");
        Log.d("EagleSDK", "productId=" + data.getProductId());
        Log.d("EagleSDK", "productName=" + data.getProductName());
        Log.d("EagleSDK", "productDesc=" + data.getProductDesc());
        Log.d("EagleSDK", "price=" + data.getPrice());
        Log.d("EagleSDK", "coinNum=" + data.getCoinNum());
        Log.d("EagleSDK", "serverId=" + data.getServerId());
        Log.d("EagleSDK", "serverName=" + data.getServerName());
        Log.d("EagleSDK", "roleId=" + data.getRoleId());
        Log.d("EagleSDK", "roleName=" + data.getRoleName());
        Log.d("EagleSDK", "roleLevel=" + data.getRoleLevel());
        Log.d("EagleSDK", "vip=" + data.getVip());
        Log.d("EagleSDK", "orderID=" + data.getOrderID());
        Log.d("EagleSDK", "extension=" + data.getExtension());
        Log.d("EagleSDK", "****PayParams Print End****");
        if (EagleSDK.getInstance().isGetOrder()) {
            this.startOrderTask(data);
        } else {
            this.payPlugin.pay(data);
        }
    }

    @SuppressLint(value={"NewApi"})
    private void startOrderTask(PayParams data) {
        GetOrderTask authTask = new GetOrderTask(data);
        if (Build.VERSION.SDK_INT >= 11) {
            authTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        } else {
            authTask.execute(new Void[0]);
        }
    }

    class GetOrderTask
    extends AsyncTask<Void, Void, EagleOrder> {
        private PayParams data;
        private ProgressDialog processTip;

        public GetOrderTask(PayParams data) {
            this.data = data;
        }

        protected void onPreExecute() {
            this.processTip = SDKTools.showProgressTip(EagleSDK.getInstance().getContext(), "\u6b63\u5728\u542f\u52a8\u652f\u4ed8\uff0c\u8bf7\u7a0d\u540e...");
        }

        protected EagleOrder doInBackground(Void ... args) {
            Log.d("EagleSDK", "begin to get order id from Eagleserver...");
            EagleOrder result = EagleProxy.getOrder(this.data);
            return result;
        }

        protected void onPostExecute(EagleOrder order) {
            SDKTools.hideProgressTip(this.processTip);
            if (order == null) {
                Log.e("EagleSDK", "get order from Eagleserver failed.");
                Toast.makeText((Context)EagleSDK.getInstance().getContext(), (CharSequence)"\u83b7\u53d6\u8ba2\u5355\u53f7\u5931\u8d25", (int)0);
                return;
            }
            this.data.setOrderID(order.getOrder());
            this.data.setExtension(order.getExtension());
            EaglePay.this.payPlugin.pay(this.data);
        }
    }
}

