/*
 * Decompiled with CFR 0.152.
 */
package com.eagle.mixsdk.sdk.plugin;

import com.eagle.mixsdk.sdk.EagleSDK;
import com.eagle.mixsdk.sdk.IUser;
import com.eagle.mixsdk.sdk.UserExtraData;
import com.eagle.mixsdk.sdk.analytics.UDAgent;
import com.eagle.mixsdk.sdk.base.PluginFactory;
import com.eagle.mixsdk.sdk.impl.SimpleDefaultUser;

public class EagleUser {
    private static EagleUser instance;
    private IUser userPlugin;

    private EagleUser() {
    }

    public void init() {
        this.userPlugin = (IUser)PluginFactory.getInstance().initPlugin(1);
        if (this.userPlugin == null) {
            this.userPlugin = new SimpleDefaultUser();
        }
    }

    public static EagleUser getInstance() {
        if (instance == null) {
            instance = new EagleUser();
        }
        return instance;
    }

    public boolean isSupport(String method) {
        if (this.userPlugin == null) {
            return false;
        }
        return this.userPlugin.isSupportMethod(method);
    }

    public void login() {
        if (this.userPlugin == null) {
            return;
        }
        this.userPlugin.login();
    }

    public void login(String customData) {
        if (this.userPlugin == null) {
            return;
        }
        this.userPlugin.loginCustom(customData);
    }

    public void switchLogin() {
        if (this.userPlugin == null) {
            return;
        }
        this.userPlugin.switchLogin();
    }

    public void showAccountCenter() {
        if (this.userPlugin == null) {
            return;
        }
        this.userPlugin.showAccountCenter();
    }

    public void logout() {
        if (this.userPlugin == null) {
            return;
        }
        this.userPlugin.logout();
    }

    public void submitExtraData(UserExtraData extraData) {
        if (this.userPlugin == null) {
            return;
        }
        if (EagleSDK.getInstance().isUseEagleAnalytics()) {
            UDAgent.getInstance().submitUserInfo(EagleSDK.getInstance().getContext(), extraData);
        }
        this.userPlugin.submitExtraData(extraData);
    }

    public void exit() {
        if (this.userPlugin == null) {
            return;
        }
        this.userPlugin.exit();
    }

    public void postGiftCode(String code) {
        if (this.userPlugin == null) {
            return;
        }
        this.userPlugin.postGiftCode(code);
    }

    public void queryProducts() {
        if (this.userPlugin == null) {
            return;
        }
        this.userPlugin.queryProducts();
    }
}

