/*
 * Decompiled with CFR 0.152.
 */
package com.eagle.mixsdk.sdk.utils;

import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class EagleHttpUtils {
    private static final String PARAMETER_SEPARATOR = "&";
    private static final String NAME_VALUE_SEPARATOR = "=";
    public static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    public static String httpGet(String urlStr, Map<String, String> params) {
        String result;
        block19: {
            result = null;
            URL url = null;
            HttpURLConnection connection = null;
            InputStreamReader in = null;
            try {
                try {
                    String paramsEncoded = "";
                    if (params != null) {
                        paramsEncoded = EagleHttpUtils.urlParamsFormat(params, "UTF-8");
                    }
                    String fullUrl = String.valueOf(urlStr) + "?" + paramsEncoded;
                    Log.d((String)"EagleSDK", (String)("the fullUrl is " + fullUrl));
                    url = new URL(fullUrl);
                    if (url.getProtocol().toUpperCase().equals("HTTPS")) {
                        EagleHttpUtils.trustAllHosts();
                        HttpsURLConnection https = (HttpsURLConnection)url.openConnection();
                        https.setHostnameVerifier(DO_NOT_VERIFY);
                        connection = https;
                    } else {
                        connection = (HttpURLConnection)url.openConnection();
                    }
                    if (connection.getResponseCode() == 200) {
                        in = new InputStreamReader(connection.getInputStream());
                        BufferedReader bufferedReader = new BufferedReader(in);
                        StringBuffer strBuffer = new StringBuffer();
                        String line = null;
                        while ((line = bufferedReader.readLine()) != null) {
                            strBuffer.append(line);
                        }
                        result = strBuffer.toString();
                        break block19;
                    }
                    Log.e((String)"EagleSDK", (String)("get connection failed. code:" + connection.getResponseCode() + ";url:" + fullUrl));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (connection != null) {
                        connection.disconnect();
                    }
                    if (in == null) break block19;
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    public static String httpPost(String urlStr, Map<String, String> params) {
        String result;
        block19: {
            result = null;
            URL url = null;
            HttpURLConnection connection = null;
            InputStreamReader in = null;
            try {
                try {
                    String paramsEncoded = "";
                    if (params != null) {
                        paramsEncoded = EagleHttpUtils.urlParamsFormat(params, "UTF-8");
                    }
                    if ((url = new URL(urlStr)).getProtocol().toUpperCase().equals("HTTPS")) {
                        EagleHttpUtils.trustAllHosts();
                        HttpsURLConnection https = (HttpsURLConnection)url.openConnection();
                        https.setHostnameVerifier(DO_NOT_VERIFY);
                        connection = https;
                    } else {
                        connection = (HttpURLConnection)url.openConnection();
                    }
                    connection.setDoInput(true);
                    connection.setDoOutput(true);
                    connection.setRequestMethod("POST");
                    connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    connection.setRequestProperty("Charset", "utf-8");
                    DataOutputStream dop = new DataOutputStream(connection.getOutputStream());
                    dop.writeBytes(paramsEncoded);
                    dop.flush();
                    dop.close();
                    if (connection.getResponseCode() == 200) {
                        in = new InputStreamReader(connection.getInputStream());
                        BufferedReader bufferedReader = new BufferedReader(in);
                        StringBuffer strBuffer = new StringBuffer();
                        String line = null;
                        while ((line = bufferedReader.readLine()) != null) {
                            strBuffer.append(line);
                        }
                        result = strBuffer.toString();
                        break block19;
                    }
                    Log.e((String)"EagleSDK", (String)("post connection failed. code:" + connection.getResponseCode() + ";url:" + urlStr));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (connection != null) {
                        connection.disconnect();
                    }
                    if (in == null) break block19;
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    public static String urlParamsFormat(Map<String, String> params, String charset) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        for (String key : params.keySet()) {
            String val = params.get(key);
            if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)val)) continue;
            String encodedName = URLEncoder.encode(key, charset);
            String encodedValue = URLEncoder.encode(val, charset);
            if (sb.length() > 0) {
                sb.append(PARAMETER_SEPARATOR);
            }
            sb.append(encodedName).append(NAME_VALUE_SEPARATOR).append(encodedValue);
        }
        return sb.toString();
    }

    public static void trustAllHosts() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

