/*
 * Decompiled with CFR 0.152.
 */
package com.eagle.mixsdk.sdk.utils;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import java.io.UnsupportedEncodingException;
import java.util.UUID;

public class GUtils {
    protected static String uuid;

    public static String getDeviceID(Context context) {
        if (uuid == null) {
            GUtils.generateDeviceID(context);
        }
        return uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void generateDeviceID(Context context) {
        if (uuid != null) return;
        Class<GUtils> clazz = GUtils.class;
        synchronized (GUtils.class) {
            if (uuid != null) return;
            SharedPreferences prefs = context.getSharedPreferences("g_device_id.xml", 0);
            String id = prefs.getString("device_id", null);
            if (id != null) {
                uuid = id;
            } else {
                String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                try {
                    String deviceId;
                    uuid = !"9774d56d682e549c".equals(androidId) ? UUID.nameUUIDFromBytes(androidId.getBytes("utf8")).toString() : ((deviceId = ((TelephonyManager)context.getSystemService("phone")).getDeviceId()) != null ? UUID.nameUUIDFromBytes(deviceId.getBytes("utf8")).toString() : UUID.randomUUID().toString());
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                prefs.edit().putString("device_id", uuid.toString()).commit();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static String getMacAddress(Context context) {
        WifiInfo localWifiInfo;
        WifiManager localWifiManager = (WifiManager)context.getSystemService("wifi");
        WifiInfo wifiInfo = localWifiInfo = localWifiManager == null ? null : localWifiManager.getConnectionInfo();
        if (localWifiInfo != null) {
            String str = localWifiInfo.getMacAddress();
            if (str == null || str.equals("")) {
                str = "null";
            }
            return str;
        }
        return "null";
    }

    public static String getScreenDpi(Activity activity) {
        DisplayMetrics dm = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
        return String.valueOf(dm.widthPixels) + "\u00d7" + dm.heightPixels;
    }
}

