/*
 * Decompiled with CFR 0.152.
 */
package com.eagle.mixsdk.sdk.verify;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import com.eagle.mixsdk.sdk.EagleSDK;
import com.eagle.mixsdk.sdk.PayParams;
import com.eagle.mixsdk.sdk.log.Log;
import com.eagle.mixsdk.sdk.utils.EagleHttpUtils;
import com.eagle.mixsdk.sdk.utils.EncryptUtils;
import com.eagle.mixsdk.sdk.utils.GUtils;
import com.eagle.mixsdk.sdk.verify.EagleOrder;
import com.eagle.mixsdk.sdk.verify.EagleToken;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class EagleProxy {
    @SuppressLint(value={"DefaultLocale"})
    public static EagleToken auth(String result) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("appID", String.valueOf(EagleSDK.getInstance().getAppID()));
            params.put("channelID", "" + EagleSDK.getInstance().getCurrChannel());
            params.put("subChannelID", "" + EagleSDK.getInstance().getSubChannel());
            params.put("extension", result);
            params.put("sdkVersionCode", EagleSDK.getInstance().getSDKVersionCode());
            params.put("deviceID", GUtils.getDeviceID((Context)EagleSDK.getInstance().getContext()));
            StringBuilder sb = new StringBuilder();
            sb.append("appID=").append(String.valueOf(EagleSDK.getInstance().getAppID())).append("channelID=").append(EagleSDK.getInstance().getCurrChannel()).append("extension=").append(result).append(EagleSDK.getInstance().getAppKey());
            String sign = EncryptUtils.md5(sb.toString()).toLowerCase();
            params.put("sign", sign);
            String authResult = EagleHttpUtils.httpGet(EagleSDK.getInstance().getAuthURL(), params);
            Log.d("EagleSDK", "sign str:" + sb.toString());
            Log.d("EagleSDK", "The sign is " + sign + " The auth result is " + authResult);
            return EagleProxy.parseAuthResult(authResult);
        }
        catch (Exception e) {
            Log.e("EagleSDK", "Eagleserver auth exception.", e);
            e.printStackTrace();
            return new EagleToken();
        }
    }

    public static EagleOrder getOrder(PayParams data) {
        EagleToken tokenInfo;
        block3: {
            try {
                tokenInfo = EagleSDK.getInstance().getUToken();
                if (tokenInfo != null) break block3;
                Log.e("EagleSDK", "The user not logined. the token is null");
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userID", "" + tokenInfo.getUserID());
        params.put("productID", data.getProductId());
        params.put("productName", data.getProductName());
        params.put("productDesc", data.getProductDesc());
        params.put("money", "" + data.getPrice() * 100);
        params.put("roleID", data.getRoleId());
        params.put("roleName", data.getRoleName());
        params.put("roleLevel", String.valueOf(data.getRoleLevel()));
        params.put("serverID", data.getServerId());
        params.put("serverName", data.getServerName());
        params.put("extension", data.getExtension());
        params.put("notifyUrl", data.getPayNotifyUrl());
        params.put("signType", "md5");
        String sign = EagleProxy.generateSign(tokenInfo, data);
        params.put("sign", sign);
        params.put("sdkVersionCode", EagleSDK.getInstance().getSDKVersionCode());
        String orderResult = EagleHttpUtils.httpPost(EagleSDK.getInstance().getOrderURL(), params);
        Log.d("EagleSDK", "The order result is " + orderResult);
        return EagleProxy.parseOrderResult(orderResult);
    }

    private static String generateSign(EagleToken token, PayParams data) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append("userID=").append(token.getUserID()).append("&").append("productID=").append(data.getProductId() == null ? "" : data.getProductId()).append("&").append("productName=").append(data.getProductName() == null ? "" : data.getProductName()).append("&").append("productDesc=").append(data.getProductDesc() == null ? "" : data.getProductDesc()).append("&").append("money=").append(data.getPrice() * 100).append("&").append("roleID=").append(data.getRoleId() == null ? "" : data.getRoleId()).append("&").append("roleName=").append(data.getRoleName() == null ? "" : data.getRoleName()).append("&").append("roleLevel=").append(data.getRoleLevel()).append("&").append("serverID=").append(data.getServerId() == null ? "" : data.getServerId()).append("&").append("serverName=").append(data.getServerName() == null ? "" : data.getServerName()).append("&").append("extension=").append(data.getExtension() == null ? "" : data.getExtension());
        if (!TextUtils.isEmpty((CharSequence)data.getPayNotifyUrl())) {
            sb.append("&notifyUrl=").append(data.getPayNotifyUrl());
        }
        sb.append(EagleSDK.getInstance().getAppKey());
        String encoded = URLEncoder.encode(sb.toString(), "UTF-8");
        Log.d("EagleSDK", "The encoded getOrderID sign is " + encoded);
        String sign = EncryptUtils.md5(encoded).toLowerCase();
        Log.d("EagleSDK", "The getOrderID sign is " + sign);
        return sign;
    }

    private static EagleToken parseAuthResult(String authResult) {
        if (authResult == null || TextUtils.isEmpty((CharSequence)authResult)) {
            return new EagleToken();
        }
        try {
            JSONObject jsonObj = new JSONObject(authResult);
            Log.d("EagleSDK", "jsonObj :" + jsonObj.toString());
            int state = jsonObj.getInt("state");
            if (state != 1) {
                Log.d("EagleSDK", "auth failed. the state is " + state);
                return new EagleToken();
            }
            JSONObject jsonData = jsonObj.getJSONObject("data");
            return new EagleToken(jsonData.getInt("userID"), jsonData.getString("sdkUserID"), jsonData.getString("username"), jsonData.getString("sdkUserName"), jsonData.getString("token"), jsonData.getString("extension"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new EagleToken();
        }
    }

    private static EagleOrder parseOrderResult(String orderResult) {
        JSONObject jsonObj;
        block3: {
            try {
                jsonObj = new JSONObject(orderResult);
                int state = jsonObj.getInt("state");
                if (state == 1) break block3;
                Log.d("EagleSDK", "get order failed. the state is " + state);
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        JSONObject jsonData = jsonObj.getJSONObject("data");
        return new EagleOrder(jsonData.getString("orderID"), jsonData.getString("extension"));
    }
}

