package com.eagle.sdk.test.order;

import java.util.HashMap;
import java.util.Map;

import org.json.JSONObject;

import com.eagle.mixsdk.sdk.EagleSDK;
import com.eagle.mixsdk.sdk.utils.EagleHttpUtils;
import com.eagle.mixsdk.sdk.utils.EncryptUtils;
import com.eagle.mixsdk.sdk.verify.EagleToken;

import android.util.Log;

public class EagleLoginUtils {

	private static final String LOGIN_URL = "http://192.168.1.106:8080/user/loginServer";
	
	/***
	 * 模拟登录游戏服
	 * @param result
	 * @return
	 */
	public static EagleAccount login(String loginUrl){
		
		try{
			
			EagleToken tokenInfo = EagleSDK.getInstance().getUToken();
			if(tokenInfo == null){
				Log.e("EagleSDK", "The user now not logined. the token is null");
				return null;
			}
			
			Map<String, String> params = new HashMap<String, String>();
			params.put("userID", ""+tokenInfo.getUserID());
			params.put("token", tokenInfo.getToken());
			
            StringBuilder sb = new StringBuilder();
            sb.append("userID=").append(tokenInfo.getUserID())
                    .append("token=").append(tokenInfo.getToken())
                    .append(EagleSDK.getInstance().getAppKey());			
			
			String sign = EncryptUtils.md5(sb.toString());
			params.put("sign", sign);
			
			String loginResult = EagleHttpUtils.httpPost(loginUrl, params);
			
			Log.d("EagleSDK", "The login result is "+loginResult);
			
			return parseLoginResult(loginResult);
			
		}catch(Exception e){
			e.printStackTrace();
		}
		
		return null;
		
	}
	
	private static EagleAccount parseLoginResult(String orderResult){
		
		try {
			JSONObject jsonObj = new JSONObject(orderResult);
			int state = jsonObj.getInt("state");
			
			if(state != 0){
				Log.d("EagleSDK", "login game failed. the state is "+ state);
				return null;
			}
			
			JSONObject jsonData = jsonObj.getJSONObject("data");
			
			return new EagleAccount(jsonData.getString("accountID"), jsonData.getString("accountName"));
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return null;
	}	
	
}
