package com.example.eaglesdk_demo;

import java.util.List;

import com.eagle.mixsdk.sdk.EagleCode;
import com.eagle.mixsdk.sdk.EagleSDK;
import com.eagle.mixsdk.sdk.PayParams;
import com.eagle.mixsdk.sdk.ProductQueryResult;
import com.eagle.mixsdk.sdk.UserExtraData;
import com.eagle.mixsdk.sdk.log.Log;
import com.eagle.mixsdk.sdk.platform.EagleExitListener;
import com.eagle.mixsdk.sdk.platform.EagleInitListener;
import com.eagle.mixsdk.sdk.platform.EaglePlatform;
import com.eagle.mixsdk.sdk.plugin.EaglePay;
import com.eagle.mixsdk.sdk.plugin.EagleRYAnalytics;
import com.eagle.mixsdk.sdk.plugin.EagleUser;
import com.eagle.mixsdk.sdk.verify.EagleToken;
import com.eagle.sdk.test.order.EagleOrder;
import com.eagle.sdk.test.order.EagleOrderUtils;
import com.ztsg.auv.R;

import android.app.Activity;
import android.content.pm.ActivityInfo;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

public class MainActivity extends Activity {

	private EditText mEditText;
	
	private Button loginBtn, sumbitDataBtn, switchBtn, payBtn, logoutBtn, exitBtn;
	
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        EaglePlatform.getInstance().init(this, new EagleInitListener() {
			
			@Override
			public void onSwitchAccount(EagleToken data) {
				
			}
			
			@Override
			public void onProductQueryResult(List<ProductQueryResult> result) {
				
			}
			
			@Override
			public void onPayResult(int code, String msg) {
			}
			
			@Override
			public void onLogout() {
				Toast.makeText(MainActivity.this, "个人中心退出帐号成功", Toast.LENGTH_SHORT).show();
			}
			
			@Override
			public void onLoginResult(int code, EagleToken data) {
				switch(code){
		        case EagleCode.CODE_LOGIN_SUCCESS:
		            //进入游戏 
		            //从EagleToken中获取用户信息
		            break;
		        }
			}
			
			@Override
			public void onInitResult(int code, String msg) {
			}

			@Override
			public void onLoginFail(int code, String msg) {
				//登录失败回调
			}
		});
        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
        EagleRYAnalytics.getInstance().initWithKeyAndChannelId(this, "guopan");
        
        mEditText = (EditText) findViewById(R.id.pay_acount);
        
        
        loginBtn = (Button) findViewById(R.id.btn_login);
        loginBtn.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View arg0) {
				login();
			}
		});
        
        
        sumbitDataBtn = (Button) findViewById(R.id.btn_sumbitData);
        sumbitDataBtn.setOnClickListener(new OnClickListener() {
			
			@Override
			public void onClick(View arg0) {
				sumbitExtraData();
			}
		});
        
        
        switchBtn = (Button) findViewById(R.id.btn_switch);
        switchBtn.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View arg0) {
				switchAccount();
			}
		});
        
        
        payBtn = (Button) findViewById(R.id.btn_pay);
        payBtn.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View arg0) {
				pay();
			}
		});
        
        
        logoutBtn = (Button) findViewById(R.id.btn_logout);
        logoutBtn.setOnClickListener(new OnClickListener() {
			
			@Override
			public void onClick(View arg0) {
				logout();
			}
		});
        
        
        exitBtn = (Button) findViewById(R.id.btn_exit);
        exitBtn.setOnClickListener(new OnClickListener() {
			
			@Override
			public void onClick(View arg0) {
				exit();
			}
		});
    }
    
    
    /**
     *登录*/
    private void login(){
    	if(EaglePlatform.getInstance().isSupportMethod("login")){
    		EaglePlatform.getInstance().login(this);
    	}
    }
    
    
    /**
     *提交扩展参数*/
    private void sumbitExtraData(){
    	if(EaglePlatform.getInstance().isSupportMethod("submitExtraData")){
    		UserExtraData data = new UserExtraData();
			data.setDataType(UserExtraData.TYPE_ENTER_GAME);
			data.setMoneyNum(100);
			data.setRoleCreateTime(System.currentTimeMillis()/1000);
			data.setRoleID("role_100");
			data.setRoleName("test_112");
			data.setRoleLevel("10");
			data.setRoleLevelUpTime(System.currentTimeMillis()/1000);
			data.setServerID(10);
			data.setServerName("server_10");
			
    		EaglePlatform.getInstance().submitExtraData(data);
    	}
    }
    
    
    /**切换账号*/
    private void switchAccount(){
    	if(EaglePlatform.getInstance().isSupportMethod("switchLogin")){
    		EagleUser.getInstance().switchLogin();
    	}
    }
    
    
    /**
     *支付*/
    private void pay(){
    	PayParams params = new PayParams();
		params.setBuyNum(1);
		params.setCoinNum(100);
		params.setExtension(System.currentTimeMillis()+"");
		params.setPrice(1);
		params.setProductId("1");
		params.setProductName("元宝");
		params.setProductDesc("100元宝");
		params.setRoleId("1");
		params.setRoleLevel(1);
		params.setRoleName("哈哈哈");
		params.setServerId("10");
		params.setServerName("雄图霸业");
		params.setVip("vip1");
    	
    	EaglePlatform.getInstance().pay(this, params);
    	
    	String orderUrl = EagleSDK.getInstance().getOrderURL();
		Log.d("EagleSDK", "the order url is "+orderUrl);
		
		OrderTask orderTask = new OrderTask(orderUrl);
		orderTask.execute(params);
    }
    
    
    private void logout(){
    	if(EaglePlatform.getInstance().isSupportMethod("logout")){
    		EaglePlatform.getInstance().logout();
    	}
    }
    
    private void exit(){
    	if(EaglePlatform.getInstance().isSupportMethod("exit")){
    		EaglePlatform.getInstance().exitSDK(new EagleExitListener() {
				@Override
				public void onGameExit() {
				}
			});
    	}
    }
    
    class OrderTask extends AsyncTask<PayParams, Void, EagleOrder>{
		private String url;
		private PayParams payParams;
		
		public OrderTask(String url){
			this.url = url;
		}
		
		protected void onPreExecute(){
		}

		@Override
		protected EagleOrder doInBackground(PayParams... args) {
			this.payParams = args[0];
			return EagleOrderUtils.getOrder(url, this.payParams);
		}
		
		protected void onPostExecute(EagleOrder order){
			onGotOrder(this.payParams, order);
		}
		
	}
    
    
    public void onGotOrder(final PayParams params, final EagleOrder order){
    	Log.e("UniSDK", "Get Order Success");
    	
    	EagleSDK.getInstance().runOnMainThread(new Runnable() {
			
			@Override
			public void run() {
				EagleOrder tempOrder = order;
		    	if(tempOrder == null){
		    		tempOrder = new EagleOrder(System.currentTimeMillis()+"", "");
		    		Toast.makeText(MainActivity.this, "获取订单号失败，随机生成测试订单号", Toast.LENGTH_SHORT);
		    	}
		    	

		    	if(tempOrder != null){
			    	Toast.makeText(MainActivity.this, "订单号:"+tempOrder.getOrder(), Toast.LENGTH_LONG).show();
			    	
			    	params.setOrderID(tempOrder.getOrder());
			    	params.setExtension(tempOrder.getExtension());
		    	}
				
				EaglePay.getInstance().pay(params);
			}
		});
    	
    }
}
